

<?php $__env->startSection('title', translate('Banner list')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/banner.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(translate('Home_Banner_Setup')); ?>

                </span>
            </h2>
        </div>

        <div class="row g-2">
            <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
                <a href="<?php echo e(route('admin.banner-add-update')); ?>" class="btn btn-primary">
                    <?php echo e(translate('Add Banner')); ?>

                </a>
            </div>
        </div>

        <div class="row g-2">
            <div class="col-12">
                <div class="card">
                    <div class="card-top px-card pt-4">
                        <div class="row align-items-center gy-2">
                            <div class="col-sm-4 col-md-6 col-lg-8">
                                <h5 class="d-flex align-items-center gap-2 mb-0">
                                    <?php echo e(translate('Banner_List')); ?>

                                    <span class="badge badge-soft-dark rounded-50 fz-12"><?php echo e($banners->total()); ?></span>
                                </h5>
                            </div>
                            <div class="col-sm-8 col-md-6 col-lg-4">
                                <form action="<?php echo e(url()->current()); ?>" method="GET">
                                    <div class="input-group">
                                        <input type="search" name="search" value="<?php echo e($search ?? ''); ?>" class="form-control" placeholder="<?php echo e(translate('Search_by_Title')); ?>" required autocomplete="off">
                                        <div class="input-group-append">
                                            <button type="submit" class="btn btn-primary"><?php echo e(translate('Search')); ?></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="py-4">
                        <div class="table-responsive datatable-custom">
                            <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                                <thead class="thead-light">
                                    <tr>
                                        <th><?php echo e(translate('SL')); ?></th>
                                        <th><?php echo e(translate('Banner_Image')); ?></th>
                                        <th><?php echo e(translate('Title')); ?></th>
                                        <th><?php echo e(translate('status')); ?></th>
                                        <th class="text-center"><?php echo e(translate('action')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($banners->firstItem() + $key); ?></td>
                                            <td><img class="img-vertical-150" src="<?php echo e(asset('storage/app/public/' . $banner->image)); ?>" alt="<?php echo e(translate('banner image')); ?>"></td>
                                            <td><?php echo e($banner->title); ?></td>
                                            <td>
                                                <label class="switcher">
                                                    <input class="switcher_input status-change" type="checkbox" <?php echo e($banner->status ? 'checked' : ''); ?>

                                                        data-url="<?php echo e(route('admin.home-banner-status', [$banner->id, $banner->status ? 0 : 1])); ?>">
                                                    <span class="switcher_control"></span>
                                                </label>
                                            </td>
                                            <td class="text-center">
                                                <a class="btn btn-outline-info btn-sm" href="<?php echo e(route('admin.banner-add-update', ['id' => $banner->id])); ?>">
                                                    <i class="tio-edit"></i>
                                                </a>
                                                <form action="<?php echo e(route('admin.banner-soft-delete', [$banner->id])); ?>" method="POST" style="display:inline-block" id="delete-form-<?php echo e($banner->id); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button" class="btn btn-outline-danger btn-sm" onclick="if(confirm('<?php echo e(translate('Want to delete this banner?')); ?>')) document.getElementById('delete-form-<?php echo e($banner->id); ?>').submit();">
                                                        <i class="tio-delete"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="table-responsive mt-4 px-3">
                            <div class="d-flex justify-content-lg-end">
                                <?php echo $banners->links(); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/rglabs/food_delivery/resources/views/admin-views/home-banner/list.blade.php ENDPATH**/ ?>