<!DOCTYPE html>
<html>
<head>
    <title>Permanent Delete  Account</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .hidden { display: none; }
    </style>
</head>
<body class="p-4">

<div class="container">
    <!-- Heading -->
    <h4 class="fw-bold" style="color: blue;">
        Permanent Delete  Account
    </h4>

    <!-- Success Message -->
    <div class="alert alert-success mt-3" role="alert">
        Account successfully suspended
    </div>

    <!-- Reason Dropdown -->
    <div class="mt-3">
        <select id="reasonSelect" class="form-select">
            <option value="">Select Reason</option>
            <option value="privacy">Privacy Concerns</option>
            <option value="not_useful">Not Useful Anymore</option>
            <option value="other">Other</option>
        </select>
    </div>

    <!-- Hidden Form -->
   <form id="extraForm" action="<?php echo e(route('account.delete.submit')); ?>" class="mt-4 hidden" method="POST" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
        <!-- Email -->
        <div class="mb-3">
            <label class="form-label">Your email address <span class="text-danger">*</span></label>
            <input type="email" class="form-control" name="email" required>
        </div>

        <!-- Description -->
        <div class="mb-3">
            <label class="form-label">Description <span class="text-danger">*</span></label>
            <textarea class="form-control" name="description" rows="3" maxlength="200" required></textarea>
            <small class="text-muted">
                Please enter the details of your request in less than 200 characters. 
                A member of our support staff will respond as soon as possible.
            </small>
        </div>

        <!-- Attachments -->
        <div class="mb-3">
            <label class="form-label">Attachments</label>
            <input type="file" class="form-control" name="attachments">
        </div>

        <!-- Acknowledgement Checkbox -->
        <div class="mb-3 form-check">
            <input type="checkbox" class="form-check-input" id="ackCheck" required>
            <label class="form-check-label" for="ackCheck">
                Check for an acknowledgement sent to your email ID after raising the request.
            </label>
        </div>

        <!-- Submit -->
        <button type="submit" class="btn btn-success px-4">SUBMIT</button>
    </form>
</div>

<script>
   document.getElementById('reasonSelect').addEventListener('change', function () {
    const form = document.getElementById('extraForm');
    if (this.value !== '') { // If any option is selected
        form.classList.remove('hidden');
    } else {
        form.classList.add('hidden');
    }
});
</script>

</body>
</html><?php /**PATH /var/www/rglabs/food_delivery/resources/views/user_account.blade.php ENDPATH**/ ?>