<?php $__env->startSection('title', translate('Customer Details')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-print-none pb-2">
            <div class="d-flex flex-wrap gap-2 align-items-center mb-3 border-bottom pb-3">
                <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                    <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/customer.png')); ?>" alt="">
                    <span class="page-header-title">
                        <?php echo e(translate('customer_Details')); ?>

                    </span>
                </h2>
            </div>

            <div class="d-flex flex-wrap gap-3 justify-content-between align-items-center mb-3">
                <div class="d-flex flex-column gap-2">
                    <h2 class="page-header-title h1"><?php echo e(translate('customer_ID')); ?> #<?php echo e($customer['id']); ?></h2>
                    <span class="">
                        <i class="tio-date-range"></i>
                        <?php echo e(translate('joined_at')); ?> : <?php echo e(date('d M Y H:i:s',strtotime($customer['created_at']))); ?>

                    </span>
                </div>

                <div class="d-flex flex-wrap gap-3 justify-content-lg-end">
                    <a class="btn btn-primary" href="<?php echo e(route('admin.customer.customer_transaction',[$customer['id']])); ?>">
                        <?php echo e(translate('point_History')); ?>

                    </a>
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-primary">
                        <i class="tio-home-outlined"></i>
                        <?php echo e(translate('dashboard')); ?>

                    </a>
                </div>
            </div>
        </div>

        <div class="row mb-2 g-2">


            <div class="col-lg-6 col-md-6 col-sm-6">
                <div class="resturant-card bg--2">
                    <img class="resturant-icon" src="<?php echo e(asset('/public/assets/admin/img/dashboard/1.png')); ?>" alt="<?php echo e(translate('dashboard')); ?>">
                    <div class="for-card-text font-weight-bold  text-uppercase mb-1"><?php echo e(translate('wallet')); ?> <?php echo e(translate('balance')); ?></div>
                    <div class="for-card-count"><?php echo e(Helpers::set_symbol($customer->wallet_balance??0)); ?></div>
                </div>
            </div>


            <div class="col-lg-6 col-md-6 col-sm-6">
                <div class="resturant-card bg--3">
                    <img class="resturant-icon" src="<?php echo e(asset('/public/assets/admin/img/dashboard/3.png')); ?>" alt="<?php echo e(translate('dashboard')); ?>">
                    <div class="for-card-text font-weight-bold  text-uppercase mb-1"><?php echo e(translate('loyalty_point')); ?> <?php echo e(translate('balance')); ?></div>
                    <div class="for-card-count"><?php echo e($customer->point??0); ?></div>
                </div>
            </div>
        </div>

        <div class="row flex-wrap-reverse g-2" id="printableArea">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-top px-card pt-4">
                        <div class="row align-items-center">
                            <div class="col-sm-4 col-md-6 col-xl-7">
                                <h5 class="d-flex gap-2 align-items-center">
                                    <?php echo e(translate('Order List')); ?>

                                    <span class="badge badge-soft-dark rounded-50 fz-12"><?php echo e($orders->total()); ?></span>
                                </h5>
                            </div>
                            <div class="col-sm-8 col-md-6 col-xl-5">
                                <form action="<?php echo e(url()->current()); ?>" method="GET">
                                    <div class="input-group">
                                        <input type="text" name="search" class="form-control" placeholder="<?php echo e(translate('Search by order ID')); ?>" aria-label="Search" value="<?php echo e($search); ?>" required="" autocomplete="off">
                                        <div class="input-group-append">
                                            <button type="submit" class="btn btn-primary"><?php echo e(translate('Search')); ?></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="py-3">
                        <div class="table-responsive datatable-custom">
                            <table id="columnSearchDatatable"
                                class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100"
                                data-hs-datatables-options='{
                                    "order": [],
                                    "orderCellsTop": true
                                }'>
                                <thead class="thead-light">
                                    <tr>
                                        <th><?php echo e(translate('SL')); ?></th>
                                        <th class="text-center"><?php echo e(translate('order_ID')); ?></th>
                                        <th class="text-center"><?php echo e(translate('total_Amount')); ?></th>
                                        <th class="text-center"><?php echo e(translate('action')); ?></th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($orders->firstItem() + $key); ?></td>
                                        <td class="table-column-pl-0 text-center">
                                            <a class="text-dark" href="<?php echo e(route('admin.orders.details',['id'=>$order['id']])); ?>"><?php echo e($order['id']); ?></a>
                                        </td>
                                        <td class="text-center"><?php echo e(Helpers::set_symbol($order['order_amount'] + $order['delivery_charge'])); ?></td>
                                        <td>
                                            <div class="d-flex justify-content-center gap-2">
                                                    <a class="btn btn-outline-success btn-sm square-btn"
                                                    href="<?php echo e(route('admin.orders.details',['id'=>$order['id']])); ?>"><i
                                                            class="tio-visible"></i></a>
                                                    <a class="btn btn-outline-info btn-sm square-btn" target="_blank"
                                                    href="<?php echo e(route('admin.orders.generate-invoice',[$order['id']])); ?>"><i
                                                            class="tio-download"></i></a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="table-responsive px-3">
                        <div class="d-flex justify-content-lg-end">
                            <?php echo $orders->links(); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-header-title d-flex gap-2"><span class="tio-user"></span> <?php echo e($customer['f_name'].' '.$customer['l_name']); ?></h4>
                    </div>

                    <?php if($customer): ?>
                        <div class="card-body">
                            <div class="media gap-3">
                                <div class="avatar avatar-xl avatar-circle">
                                    <img
                                        class="img-fit rounded-circle"
                                        src="<?php echo e($customer->imageFullPath); ?>"
                                        alt="<?php echo e(translate('Image Description')); ?>">
                                </div>
                                <div class="media-body d-flex flex-column gap-1">
                                    <div class="text-dark d-flex gap-2 align-items-center"><span class="tio-email"></span> <a class="text-dark" href="mailto:<?php echo e($customer['email']); ?>"><?php echo e($customer['email']); ?></a></div>
                                    <div class="text-dark d-flex gap-2 align-items-center"><span class="tio-call-talking-quiet"></span> <a class="text-dark" href="tel:<?php echo e($customer['phone']); ?>"><?php echo e($customer['phone']); ?></a></div>
                                    <div class="text-dark d-flex gap-2 align-items-center"><span class="tio-shopping-basket-outlined"></span> <?php echo e($customer->orders->count()); ?> <?php echo e(translate('orders')); ?></div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="card mt-3">
                    <div class="card-header">
                        <h4 class="card-header-title d-flex gap-2"><span class="tio-home"></span> <?php echo e(translate('addresses')); ?></h4>
                    </div>

                    <?php if($customer): ?>
                        <div class="card-body">
                            <?php $__currentLoopData = $customer->addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <ul class="list-unstyled list-unstyled-py-2">
                                    <li>
                                        <i class="tio-city mr-2"></i>
                                        <?php echo e($address['address_type']); ?>

                                    </li>
                                    <li>
                                        <i class="tio-call-talking-quiet mr-2"></i>
                                        <?php echo e($address['contact_person_number']); ?>

                                    </li>
                                    <li class="li-pointer">
                                        <a class="text-muted" target="_blank"
                                           href="http://maps.google.com/maps?z=12&t=m&q=loc:<?php echo e($address['latitude']); ?>+<?php echo e($address['longitude']); ?>">
                                            <i class="tio-map mr-2"></i>
                                            <?php echo e($address['address']); ?>

                                        </a>
                                    </li>
                                </ul>
                                <hr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade point-example-modal-sm" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel"
         aria-hidden="true">
        <div class="modal-dialog modal-sm" role="document">
            <div class="modal-content">
                <div class="modal-header">

                    <h5 class="modal-title h4" id="mySmallModalLabel"> <?php echo e(translate('add')); ?> <?php echo e(translate('point')); ?> </h5>
                    <button type="button" class="btn btn-xs btn-icon btn-ghost-secondary" data-dismiss="modal"
                            aria-label="Close">
                        <i class="tio-clear tio-lg"></i>
                    </button>
                </div>

                <form action="<?php echo e(route('admin.customer.AddPoint',[$customer['id']])); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <input type="number" name="point" class="form-control" min="1" max="100000"
                                   placeholder="<?php echo e(translate('EX')); ?> : 100" required>
                        </div>
                        <button class="btn btn-primary"><?php echo e(translate('submit')); ?></button>
                    </div>
                </form>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
        <script src="<?php echo e(asset('public/assets/admin/js/customer-view.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/rglabs/food_delivery/resources/views/admin-views/customer/customer-view.blade.php ENDPATH**/ ?>