<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="google-site-verification" content="mIp5gyTvURmjX2S1ptolK4i0fnhz_rQ9icK_sVpahvk" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta name="csrf-token" content="{{csrf_token()}}">
        {{-- <title>Manu's Kitchen</title> --}}
        <title>@yield('title')</title>
        <!-- CSS -->
        <link rel="stylesheet" href="{{asset('public/assets/installation')}}/assets/plugins/bootstrap/css/bootstrap.min.css"/>
        <link rel="stylesheet" href="{{asset('public/assets/installation')}}/assets/plugins/swiper/swiper-bundle.min.css" />
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css"/>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"/>
        <link rel="stylesheet" href="{{asset('public/assets/installation')}}/assets/css/new_style.css">
        {{-- <link rel="stylesheet" href="assets/css/style.css" /> --}}
        <link rel="stylesheet" href="{{asset('public/assets/installation')}}/assets/css/responsive.css" />
        {{-- <link rel="stylesheet" href="{{asset('public/assets/admin')}}/css/toastr.css"> --}}
        <script src="{{asset('public/assets/installation')}}/assets/js/jquery-3.7.1.min.js"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
        <style>
            /* App store buttons sizes */
            .store-btn {
                max-width: 140px;
            }
            .store-btn-sm {
                max-width: 120px;
            }
            .banner-img {
                max-height: 350px;
                width: auto;
            }

            /* Tablet and below */
            @media (max-width: 991px) {
                .modalText {
                    padding: 0 15px;
                }
                .store-btn {
                    max-width: 120px;
                }
                .banner-img {
                    max-height: 280px;
                }
            }

            /* Mobile screens */
            @media (max-width: 575px) {
                .store-btn, .store-btn-sm {
                    max-width: 100px;
                }
                .sectionHead h2 {
                    font-size: 1.5rem;
                }
                .banner-img {
                    max-height: 200px;
                }
            }
        </style>
    </head>
    <body>
        <!-- Header -->
        <header class="header">
            <nav class="navbar navbar-expand-lg bg-body-tertiary">
                <div class="container">
                <a class="navbar-brand" href="{{route('home-index')}}">
                    <img src="{{asset('public/assets/installation')}}/assets/images/logo.svg" alt="logo" class="img-fluid" />
                </a>
                <button
                    class="navbar-toggler collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#navbarTogglerDemo02"
                    aria-controls="navbarTogglerDemo02"
                    aria-expanded="false"
                    aria-label="Toggle navigation"
                >
                    <span class="navbar-toggler-icon"></span>
                </button>
                    <div class="collapse navbar-collapse" id="navbarTogglerDemo02">
                        <ul class="navbar-nav gap-5 mx-auto mb-2 mb-lg-0">
                        <li class="nav-item">
                            <a class="nav-link {{Request::is('home-index')?'active':''}}" href="{{route('home-index')}}">Home</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{Request::is('contact-us')?'active':''}}" href="{{route('contact-us')}}">Contact Us</a>
                        </li>
                        </ul>
                        <div class="text-center">
                            <a href="{{ asset('public/apk/kitchen.apk') }}" style="text-decoration: none; color: inherit;" download>
                                <button class="btn btn-primary" type="submit">
                                    <i class="bi bi-download me-2"></i>Downloads
                                </button>
                            </a>
                        </div>
                    </div>
                </div>
            </nav>
            @stack('css_or_js')
        </header>
        @yield('content')
        <footer class="footer pb-0">
            <div class="container">
                <div class="row justify-content-between">
                    <div class="col-md-4">
                        <div class="footerLinks d-flex flex-column gap-2">
                            <div class="logo">
                                <img
                                    src="{{asset('public/assets/installation')}}/assets/images/logo.svg"
                                    alt="logo"
                                    class="img-fluid"
                                />
                            </div>
                            <p>
                                From kitchen to you—fresh, fast, flawless
                            </p>
                            <ul class="unstyled ps-0 d-flex flex-column">
                                <li>
                                    <a href="mailto:info@manuskitchen.com"
                                    ><i class="bi bi-envelope-open-fill me-3"></i
                                    >manuskitchen1986@gmail.com</a
                                    >
                                </li>
                                <li>
                                    <a href="tel:684 555-0102 490"
                                    ><i class="bi bi-telephone-fill me-3"></i>70074 97552</a
                                    >
                                </li>
                                <li>
                                    <p>
                                        <i class="bi bi-geo-alt-fill me-3"></i>Address: BINA, JHULANTALI, Bina Road
                                        Jhulan Road Parasi, Uttar Pradesh, 231220
                                    </p>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="footerLinks">
                            <h6>Company</h6>
                            <ul class="unstyled ps-0 d-flex flex-column">
                                <li>
                                    <a href="{{route('home-index')}}">Home</a>
                                </li>
                                <li>
                                    <a href="{{route('contact-us')}}">Contact Us</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="footerLinks">
                            <h6>Quick Links</h6>
                            <ul class="unstyled ps-0 d-flex flex-column">
                                <li>
                                    <a href="{{route('about-us')}}">About Us</a>
                                </li>
                                <li>
                                    <a href="{{route('terms-and-conditions')}}">Terms and Conditions</a>
                                </li>
                                <li>
                                    <a href="{{route('refund-cancellation')}}">Refund and Cancellation</a>
                                </li>
                                <li>
                                    <a href="{{route('privacy-policy')}}">Privacy Policy</a>
                                </li>
                                <li>
                                    <a href="{{route('shipping-policy')}}">Shipping Policies</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="footerLinks">
                            <h6>Social Media Links</h6>
                            <div class="d-flex flex-column gap-3">
                                {{-- <div class="newsLatter position-relative">
                                    <input
                                    type="text"
                                    class="form-control"
                                    placeholder="Enter Email Adress"
                                    />
                                    <button><i class="bi bi-send-fill"></i></button>
                                </div>
                                <div class="form-check d-flex align-items-start gap-2">
                                    <input
                                    class="form-check-input"
                                    type="checkbox"
                                    name="gridRadios"
                                    id="gridRadios1"
                                    value="option1"
                                    checked
                                    />
                                    <label class="form-check-label" for="gridRadios1">
                                    I agree to all your terms and policies
                                    </label>
                                </div> --}}
                                @php
                                $social_media= \App\Model\SocialMedia::where('status',1)->get();
                                @endphp
                                <ul class="unstyled ps-0 d-flex gap-4">
                                    @foreach($social_media as $social_medias)
                                        {{-- @if($social_medias->name === 'facebook')
                                            <li>
                                                <a href="{{$social_medias->link}}"><i class="fa-brands fa-facebook-f"></i></a>
                                            </li>
                                        @elseif($social_medias->name === 'twitter')
                                            <li>
                                                <a href="{{$social_medias->link}}"><i class="fa-brands fa-x-twitter"></i></a>
                                            </li>
                                        @elseif($social_medias->name === 'pinterest')
                                            <li>
                                                <a href="{{$social_medias->link}}"><i class="fa-brands fa-pinterest"></i></a>
                                            </li> --}}
                                        @if($social_medias->name === 'instagram')
                                            <li>
                                                <a href="{{$social_medias->link}}"><i class="fa-brands fa-instagram"></i></a>
                                            </li>
                                        @endif 
                                    @endforeach
                                 </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="copyRight mt-5">
                <div class="container">
                    <p class="copyright-text mb-0">Copyright © {{ date('Y') }} by Manu’s. {{ translate('All Rights Reserved') }}</p>
                    {{-- <p>Copyright © 2025 by Manu’s. All Rights Reserved</p> --}}
                </div>
            </div>
        </footer>
        <!-- Footer -->
        <!-- Button trigger modal -->
        <!-- Modal -->
        <div class="modal fade downloadModal" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false"
            tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true" style="z-index: 9999">
            <div class="modal-dialog modal-dialog-centered modal-xl">
                <div class="modal-content">
                    <div class="modal-header border-0">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="bi bi-x-lg"></i>
                        </button>
                    </div>
                    <div class="modal-body p-3">
                        <div class="row align-items-center">
                            
                            <!-- Left Content -->
                            <div class="col-lg-7 col-md-12 text-center text-lg-start">
                                <div class="modalText">
                                    <div class="sectionHead mb-4">
                                        <h2 class="fw-bold fs-2 fs-md-3 fs-lg-1">Download the App Now!</h2>
                                        <p class="mb-0">From Manu’s Kitchen to Your Table — With Love</p>
                                    </div>

                                    <!-- Top button -->
                                    <div class="downloadBtn mb-4">
                                        <a href="{{ asset('public/apk/kitchen.apk') }}" style="text-decoration: none; color: inherit;" download><h5>Download Now</h5></a>
                                    </div>

                                    <!-- Two side-by-side buttons -->
                                    <div class="d-flex flex-column flex-md-row justify-content-center justify-content-lg-start gap-4">
                                        <div class="downloadBtn text-center">
                                            <h5>User</h5>
                                            <div class="d-flex flex-wrap justify-content-center gap-3">
                                                <a href="#">
                                                    <img src="{{asset('public/assets/installation')}}/assets/images/andriod.png" alt="Android" 
                                                        class="img-fluid store-btn-sm">
                                                </a>
                                                <a href="#">
                                                    <img src="{{asset('public/assets/installation')}}/assets/images/appstore.png" alt="App Store" 
                                                        class="img-fluid store-btn-sm">
                                                </a>
                                            </div>
                                        </div>

                                        <div class="downloadBtn text-center">
                                            <h5>User</h5>
                                            <div class="d-flex flex-wrap justify-content-center gap-3">
                                                <a href="#">
                                                    <img src="{{asset('public/assets/installation')}}/assets/images/andriod.png" alt="Android" 
                                                        class="img-fluid store-btn-sm">
                                                </a>
                                                <a href="#">
                                                    <img src="{{asset('public/assets/installation')}}/assets/images/appstore.png" alt="App Store" 
                                                        class="img-fluid store-btn-sm">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Right Image -->
                            <div class="col-lg-5 col-md-12 mt-4 mt-lg-0 text-center text-lg-end">
                                <img src="{{asset('public/assets/installation')}}/assets/images/modalbanner.png" alt="banner" class="img-fluid banner-img">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>



        <!-- SCRIPT -->
        {{-- @stack('script') --}}
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
        {{-- <script src="{{asset('public/assets/admin')}}/js/toastr.js"></script> --}}
        <script src="{{asset('public/assets/admin')}}/js/sweet_alert.js"></script>
        <script src="{{asset('public/assets/installation')}}/assets/plugins/bootstrap/js/bootstrap.bundle.js"></script>
        <script src="{{asset('public/assets/installation')}}/assets/plugins/swiper/swiper-bundle.min.js"></script>
        <script src="{{asset('public/assets/installation')}}/assets/js/new_script.js"></script>
        {!! Toastr::message() !!}
        <script>
            @if ($errors->any())
                @foreach($errors->all() as $error)
                    toastr.error("{{ $error }}", "Error", {
                        closeButton: true,
                        progressBar: true
                    });
                @endforeach
            @endif
        </script>
    </body>
</html>