@extends('layouts.admin.app')

@section('title', translate('Testimonial list'))

@section('content')
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="{{asset('public/assets/admin/img/icons/banner.png')}}" alt="">
                <span class="page-header-title">
                    {{translate('Home_Testimonial_Setup')}}
                </span>
            </h2>
        </div>

        <div class="row g-2">
            <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
                <a href="{{ route('admin.testimonial-add-update') }}" class="btn btn-primary">
                    {{ translate('Add Testimonial') }}
                </a>
            </div>
        </div>

        <div class="row g-2">
            <div class="col-12">
                <div class="card">
                    <div class="card-top px-card pt-4">
                        <div class="row align-items-center gy-2">
                            <div class="col-sm-4 col-md-6 col-lg-8">
                                <h5 class="d-flex align-items-center gap-2 mb-0">
                                    {{translate('Testimonial_List')}}
                                    <span class="badge badge-soft-dark rounded-50 fz-12">{{ $testimonials->total() }}</span>
                                </h5>
                            </div>
                            <div class="col-sm-8 col-md-6 col-lg-4">
                                <form action="{{ url()->current() }}" method="GET">
                                    <div class="input-group">
                                        <input type="search" name="search" value="{{ $search ?? '' }}" class="form-control" placeholder="{{translate('Search_by_Title')}}" required autocomplete="off">
                                        <div class="input-group-append">
                                            <button type="submit" class="btn btn-primary">{{translate('Search')}}</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="py-4">
                        <div class="table-responsive datatable-custom">
                            <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                                <thead class="thead-light">
                                    <tr>
                                        <th>{{translate('SL')}}</th>
                                        <th>{{translate('User Image')}}</th>
                                        <th>{{translate('User Name')}}</th>
                                        <th>{{translate('Designation')}}</th>
                                        <th>{{translate('Description')}}</th>
                                        <th>{{translate('Rating')}}</th>
                                        <th>{{translate('status')}}</th>
                                        <th class="text-center">{{translate('action')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($testimonials as $key => $testimonial)
                                        <tr>
                                            <td>{{$testimonials->firstItem() + $key }}</td>
                                            <td><img class="img-vertical-150" src="{{ asset('storage/app/public/' . $testimonial->customer_image) }}" alt="{{ translate('testimonial image') }}"></td>
                                            <td>{{ $testimonial->customer_name }}</td>
                                            <td>{{ $testimonial->customer_designation }}</td>
                                            <td>{{ $testimonial->description }}</td>
                                            <td>{{ $testimonial->star_rating }}</td>
                                            <td>
                                                <label class="switcher">
                                                    <input class="switcher_input status-change" type="checkbox" {{ $testimonial->status ? 'checked' : '' }}
                                                        data-url="{{ route('admin.testimonial-status', [$testimonial->id, $testimonial->status ? 0 : 1]) }}">
                                                    <span class="switcher_control"></span>
                                                </label>
                                            </td>
                                            <td class="text-center">
                                                <a class="btn btn-outline-info btn-sm" href="{{ route('admin.testimonial-add-update', ['id' => $testimonial->id]) }}">
                                                    <i class="tio-edit"></i>
                                                </a>
                                                <form action="{{ route('admin.testimonial-soft-delete', [$testimonial->id]) }}" method="POST" style="display:inline-block" id="delete-form-{{$testimonial->id}}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="button" class="btn btn-outline-danger btn-sm" onclick="if(confirm('{{translate('Want to delete this testimonial?')}}')) document.getElementById('delete-form-{{$testimonial->id}}').submit();">
                                                        <i class="tio-delete"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="table-responsive mt-4 px-3">
                            <div class="d-flex justify-content-lg-end">
                                {!! $testimonials->links() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
