@extends('layouts.admin.app')

@section('title', isset($home_banner) ? translate('Update banner') : translate('Add banner'))

@section('content')
<div class="content container-fluid">
    <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
        <h2 class="h1 mb-0 d-flex align-items-center gap-2">
            <img width="20" class="avatar-img" src="{{ asset('public/assets/admin/img/icons/banner.png') }}" alt="">
            <span class="page-header-title">
                {{ isset($home_banner) ? translate('Update_Banner') : translate('Add_Banner') }}
            </span>
        </h2>
    </div>
    <div class="row gx-2 gx-lg-3">
        <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
            <form action="{{ route('admin.banner-add-update-store') }}" method="post" enctype="multipart/form-data">
                @csrf
                @if(isset($home_banner))
                    @method('put')
                    <input type="hidden" name="id" value="{{ $home_banner->id }}">
                @endif
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="input-label">{{ translate('title') }} <span class="text-danger ml-1">*</span></label>
                                    <input type="text" name="title" value="{{ old('title', $home_banner->title ?? '') }}" class="form-control" placeholder="{{ translate('New banner') }}" required>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="input-label">{{ translate('banner_Image') }} <span class="text-danger ml-1">*</span></label>
                                    <div class="d-flex justify-content-center mt-4">
                                        <div class="upload-file">
                                            <input type="file" name="image" accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*" class="upload-file__input">
                                            <div class="upload-file__img_drag upload-file__img max-h-200px overflow-hidden">
                                                <img width="465" src="{{ isset($home_banner) ? asset('storage/app/public/' . $home_banner->image) : asset('public/assets/admin/img/placeholder.png') }}" alt="{{ translate('banner image') }}" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex justify-content-end gap-3 mt-4">
                            <button type="submit" class="btn btn-primary">{{ isset($home_banner) ? translate('update') : translate('submit') }}</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('script_2')
<script>
    "use strict";
    function readURL(input) {
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = function (e) {
                $('.upload-file__img img').attr('src', e.target.result);
            };
            reader.readAsDataURL(input.files[0]);
        }
    }
    $(".upload-file__input").change(function () {
        readURL(this);
    });
</script>
@endpush
