<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

Class Testimonial extends Model
{
    protected $casts = [
        'description' => 'string',
        'customer_name' => 'string',
        'customer_designation' => 'string',
        'customer_image' => 'string',
        'star_rating' => 'integer',
        'status' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    public function getImageFullPathAttribute(): string
    {
        $image = $this->image ?? null;
        $path = asset('public/assets/admin/img/icons/upload_img2.png');

        if (!is_null($image) && Storage::disk('public')->exists('/' . $image)) {
            $path = asset('storage/app/public/testimonials/' . $image);
        }
        return $path;
    }
}