<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use App\Model\Users;
use CfPayout;
use App\Transaction;
use App\libraries\CustomHelper;
use Mail,Session,URL,View,Validator,Redirect;

class WebhookController extends Controller {

  public function cashfree_return_url($id=null) {
    if(!empty($id)) {
      $result=array();
      $url = CASHFREE_GATEWAY_URL."$id/payments";
      $headers = [
        "x-client-id: ".CASHFREE_APP_ID,
        "x-client-secret: ".CASHFREE_SECRET_KEY,
        "Accept: application/json",
        "x-api-version: 2023-08-01",
      ];

      $ch = curl_init($url);
      curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

      $response = curl_exec($ch);

      if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);die;
      } else {
        $result= json_decode($response);
      }
      curl_close($ch);

      if(!empty($result)){
        if(empty($result->code)){
          $res=$result[0];
          if($res->payment_status=="SUCCESS") {
            echo '<h5>SUCCESS</h5>';
            echo '<p>Money added successfully</p>';
            echo '<h4>₹'.$res->payment_amount.'</h4>';
            echo '<small>to your account!</small>';
            echo '<h6>Transaction ID: '.$res->cf_payment_id.'</h6>';
            echo '<button>Done</button>';
            die;
          } elseif($res->payment_status=="PENDING") {
            echo '<h5>PENDING</h5>';
            echo '<p>Your payment status is pending</p>';
            echo '<h4>₹'.$res->payment_amount.'</h4>';
            echo '<small>to your account!</small>';
            echo '<h6>Transaction ID: '.$res->cf_payment_id.'</h6>';
            echo '<button>Done</button>';
            die;
          } elseif($res->payment_status=="USER_DROPPED") {
            echo '<h5>USER DROPPED</h5>';
            echo '<p>Your payment is dropped</p>';
            echo '<h4>₹'.$res->payment_amount.'</h4>';
            echo '<small>to your account!</small>';
            echo '<h6>Transaction ID: '.$res->cf_payment_id.'</h6>';
            echo '<button>Done</button>';
            die;
          } elseif($res->payment_status=="FAILED") {
            echo '<h5>FAILED</h5>';
            echo '<p>Your payment is dropped</p>';
            echo '<h4>₹'.$res->payment_amount.'</h4>';
            echo '<small>to your account!</small>';
            echo '<h6>Transaction ID: '.$res->cf_payment_id.'</h6>';
            if(!empty($res->error_details) && !empty($res->error_details->error_description)) {
              echo '<i>'.$res->error_details->error_description.'</i><br>';
            }
            echo '<button>Done</button>';
            die;
          }
        } else {
          echo '<h5>FAILED</h5>';
          echo '<p>Payment unsuccessful</p>';
          echo '<h4></h4>';
          echo '<small>Something went wrong</small>';
          echo '<h6>Please try again</h6>';
          echo '<button>Try again</button>';
          die;
        }
      }
    }

    echo '<h5>cancelTransaction</h5>';
    echo '<p>Transaction Cancelled</p>';
    echo '<h4></h4>';
    echo '<small></small>';
    echo '<h6>Please try again</h6>';
    echo '<button>Try again</button>';
    die;
  }

  public function cashfree_notify_url(Request $request,$id) {
    date_default_timezone_set('Asia/Kolkata');
    \Log::info('cashfree_notify_url: '.json_encode($request->all())); //die;
    \Log::info('cashfree_notify_url_header: '.json_encode($request->header())); //die;
    $headers = $request->header();

    //$result='{"data":{"order":{"order_id":"CFP-173211041555","order_amount":100,"order_currency":"INR","order_tags":null},"payment":{"cf_payment_id":5114915066992,"payment_status":"SUCCESS","payment_amount":100,"payment_currency":"INR","payment_message":null,"payment_time":"2024-11-20T19:17:25+05:30","bank_reference":null,"auth_id":null,"payment_method":{"upi":{"channel":null,"upi_id":null}},"payment_group":"upi"},"customer_details":{"customer_name":null,"customer_id":"akshat151","customer_email":null,"customer_phone":"8209420306"},"payment_gateway_details":{"gateway_name":"CASHFREE","gateway_order_id":"2188146033","gateway_payment_id":"5114915066992","gateway_status_code":null,"gateway_order_reference_id":"null","gateway_settlement":"CASHFREE"},"payment_offers":null},"event_time":"2024-11-20T19:17:44+05:30","type":"PAYMENT_SUCCESS_WEBHOOK"}';

    $res=$request->all();
    if(!empty($res)) {
      $jsonData=json_encode($res);
      $transaction_id=$id;
      $paymentId=NULL;
      $transaction_row = DB::table('transactions')->where('transaction_id', $transaction_id)->where('paymentstatus', 'pending')->first();
      
      if(!empty($transaction_row)) {
        if($res['type']=='PAYMENT_SUCCESS_WEBHOOK' && !empty($res['data'])){
          if(!empty($res['data']['payment']['payment_status']) && $res['data']['payment']['payment_status']=='SUCCESS'  && !empty($res['data']['order']['order_id']) && $res['data']['order']['order_id']==$transaction_id) {
            if(!empty($res['data']['payment']['cf_payment_id'])) {
              $paymentId=$res['data']['payment']['cf_payment_id'];
            }

            $payment_method=@$res['data']['payment']['payment_group'];
            $res=$this->update_transaction_status($transaction_row->id,'SUCCESS',$paymentId,$jsonData,$payment_method);
            echo "Success: $res";
            // $this->senddepositMail($transaction_row->userid,$transaction_row->amount,$transaction_id,$payment_method);
            die;
          } else {
            //if($res['payInstrument']['responseDetails']['statusCode']=='OTS0000' && $res['payInstrument']['responseDetails']['message']=="SUCCESS")
            $this->update_transaction_status($transaction_row->id,'FAIL',$paymentId,$jsonData);
            echo 'Fail';
            die;
          }
        }
      }
    }
    die('Nothing Happen');
  }
}
