<?php

namespace App\Http\Controllers\Api\Payment;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\WalletController;
use App\Http\Controllers\Api\PackageController;
use Illuminate\Support\Facades\Http;

class CashfreeController extends Controller
{
    public function payWithCashfree(Request $request)
    {
        $payment_type   = $request->payment_type;
        $amount         = $request->amount;
        $payment_method = $request->payment_method;
        $package_id     = $request->package_id ?? 0;

        return view('frontend.payment_gateway.cashfree_app', compact('amount', 'package_id', 'payment_method', 'payment_type'));
    }

    public function createOrder(Request $request)
    {
        $currency = \App\Models\Currency::findOrFail(get_setting('system_default_currency'))->code;
        $order_id = 'ORDER_' . time();
        if($request->user_id == 158){
            $request->amount = 1;
        }
        $response = Http::withHeaders([
            'x-client-id' => '946395381c8f448dab3e44edaf593649',
            'x-client-secret' => 'cfsk_ma_prod_59db70c409884633080beb22a196c7a4_1f475165',
            'x-api-version' => '2025-01-01',
            'Content-Type' => 'application/json',
        // ])->post('https://sandbox.cashfree.com/pg/orders', [
        ])->post('https://api.cashfree.com/pg/orders', [
            'order_amount' => $request->amount,
            'order_currency' => $currency,
            'order_id' => $order_id,
            'customer_details' => [
                'customer_id' => $request->user_id,
                'customer_email' => $request->email,
                'customer_phone' => $request->phone,
            ],
            'order_meta' => [
                'return_url' => url('/api/cashfree/success?order_id=' . $order_id . '&user_id=' . $request->user_id . '&package_id=' . $request->package_id . '&payment_type=' . $request->payment_type),
                'notify_url' => "https://admin.thejinnee.com/api/web-hook-url"
            ],
        ]);
        // echo"<pre>";
        // print_r($response->json());
        // die;
        
        // if(env('CASHFREE_APP_ID') == 'TEST105502512f84bbc942ebf345507615205501'){
        //     $env = 'SANDBOX';
        // }else{
            $env = 'PRODUCTION';
        // }
        return response()->json(['result' => true, 'message' => "Order Created Successfully", 'data' => $response->json(),'cashfree_env' => $env]);
    }

    // public function paymentStatus(Request $request)
    // {
    //     try {
    //         $order_id = $request->order_id;
    //         $cf_payment_id = $request->cf_payment_id;

    //         $statusResponse = Http::withHeaders([
    //             'x-client-id' => env('CASHFREE_APP_ID'),
    //             'x-client-secret' => env('CASHFREE_SECRET_KEY'),
    //             'x-api-version' => '2023-08-01',
    //             'Content-Type' => 'application/json',
    //         ])->get("https://sandbox.cashfree.com/pg/orders/{$order_id}/payments/{$cf_payment_id}");
    //         echo'<pre>';
    //                 print_r($statusResponse->json());
    //                 die;
    //         if ($statusResponse->successful()) {
    //             $response  = $statusResponse->json();
    //             if (!empty($response['payments']) && isset($response['payments'][0]['payment_status'])) {
    //                 $order = $response['payments'][0]; // Get the first payment record
    //                 // echo'<pre>';
    //                 // print_r($order);
    //                 // die;
    //                 if ($order['payment_status'] === 'SUCCESS') {
    //                     $payment_details = json_encode([
    //                         'order_id' => $order_id,
    //                         'payment_method' => $order['payment_method']['upi']['channel'] ?? 'cashfree',
    //                         'amount' => $order['order_amount'],
    //                         'currency' => $order['payment_currency'],
    //                     ]);

    //                     $payment_data = [
    //                         "package_id" => $request->package_id,
    //                         "payment_method" => $request->payment_method,
    //                         "amount" => $order['order_amount'],
    //                     ];

    //                     if ($request->payment_type == 'package_payment') {
    //                         $packagePaymentController = new PackageController;
    //                         return $packagePaymentController->package_payment_done($request->user_id, $payment_data, $payment_details);
    //                     } elseif ($request->payment_type == 'wallet_payment') {
    //                         $walletController = new WalletController;
    //                         return $walletController->wallet_payment_done($request->user_id, $payment_data, $payment_details);
    //                     }
    //                 }
    //             }
    //         }

    //         return response()->json(['result' => false, 'message' => 'Payment not completed.']);
    //     } catch (\Exception $e) {
    //         return response()->json(['result' => false, 'message' => $e->getMessage()]);
    //     }
    // }

    // public function success(Request $request)
    // {
    //     try {
    //         $payment_data = [
    //             "package_id" => $request->package_id,
    //             "payment_method" => $request->payment_method,
    //             "amount" => $request->amount,
    //         ];
    //         $response = $request->payment_details;
    //         if ($request->payment_type == 'package_payment') {
    //             $packagePaymentController = new PackageController;
    //             return $packagePaymentController->package_payment_done($request->user_id, $payment_data, json_encode($response));
    //         } elseif ($request->payment_type == 'wallet_payment') {
    //             $walletController = new WalletController;
    //             return $walletController->wallet_payment_done($request->user_id, $payment_data, json_encode($response));
    //         }
    //     } catch (\Exception $e) {
    //         return response()->json(['result' => false, 'message' => $e->getMessage()]);
    //     }
    // }
    public function success(Request $request)
    {
        $order_id = $request->query('order_id');
        $user_id = $request->query('user_id');
        $package_id = $request->query('package_id');
        $payment_type = $request->query('payment_type', 'package_payment'); // default if missing
        if (!$order_id || !$user_id || !$package_id) {
            return response()->json([
                'result' => false,
                'message' => 'Missing required parameters.',
            ]);
        }
        // $order_id = $request->order_id; // Sent back from Cashfree as a query parameter
        // Step 1: Fetch payment status from Cashfree
        $statusResponse = Http::withHeaders([
            'x-client-id' => '946395381c8f448dab3e44edaf593649',
            'x-client-secret' => 'cfsk_ma_prod_59db70c409884633080beb22a196c7a4_1f475165',
            'x-api-version' => '2025-01-01',
            'Content-Type' => 'application/json',
        // ])->get("https://sandbox.cashfree.com/pg/orders/{$order_id}");
        ])->get("https://api.cashfree.com/pg/orders/{$order_id}");
        if (!$statusResponse->successful()) {
            return response()->json([
                'result' => false,
                'message' => 'Unable to verify payment with Cashfree.',
            ]);
        }
        $order = $statusResponse->json();
        // Step 2: Check status
        if ($order['order_status'] === 'PAID') {
            // Optional: Extract metadata if you passed it during order creation
            $payment_method = $order['payment_session_id'] ?? 'Cashfree';
            $amount         = $order['order_amount'];
            $payment_data = [
                'package_id' => $package_id,
                'payment_method' => $payment_method,
                'amount' => $amount,
            ];
            $payment_status = ['status' => 'Success'];
            try {
                if ($payment_type === 'package_payment') {
                    $packagePaymentController = new PackageController;
                    return $packagePaymentController->package_payment_done($user_id, $payment_data, json_encode($payment_status));
                } elseif ($payment_type === 'wallet_payment') {
                    $walletController = new WalletController;
                    return $walletController->wallet_payment_done($user_id, $payment_data, json_encode($payment_status));
                } else {
                    return response()->json([
                        'result' => false,
                        'message' => 'Invalid payment type.',
                    ]);
                }
            } catch (\Exception $e) {
                return response()->json([
                    'result' => false,
                    'message' => 'Error while processing payment: ' . $e->getMessage(),
                ]);
            }
        } else {
            return response()->json([
                'result' => false,
                'message' => 'Payment not successful.',
                'status' => $order['order_status']
            ]);
        }
    }
}